<?php
function logfile()
{
	if (func_num_args()>1) $filename=func_get_arg(1);
   	else $filename="logfile.txt";

	if (file_exists($filename))
	{
		if (filesize($filename)>64000000) $base = fopen($filename, "w");
		else $base = fopen($filename, "a");
	
		fwrite($base,func_get_arg(0).chr(13).chr(10));
		fclose($base);
		return 1;
	}	
	return 0;
}	

function sqlconnect($server,$uid,$pw,$database)
{
   $handle=mysqli_connect($server,$uid,$pw,$database);
   $cmd="set names latin1";
   mysqli_query($handle,$cmd);
   return $handle;
}

function sqlcmd($handle,$cmd)
{
   logfile($cmd);
   return mysqli_query($handle,$cmd);
}

function sqlread($result)
{   
   //echo $result;
   return mysqli_fetch_array($result);
}
  
function sqlfield($result,$num)
{
   return mysqli_field_name($result,$num);
}

function sqlfcount($result)
{
   return mysqli_num_fields($result);
}

function sqlseek($result,$recno)
{
   return mysqli_data_seek($result,$recno);
}

function sqlcount($result)
{
   return mysqli_num_rows($result);
}

function sqltime($handle)
{
	$handle=func_get_arg(0);
	if (func_num_args()>1) 
	{
		$cmd="SELECT CONVERT_TZ(sysdate(),'SYSTEM','".func_get_arg(1)."')";
	}	
   	else $cmd="select sysdate()";
	if ($handle) $result=sqlcmd($handle,$cmd);
	if (($result)&&(sqlcount($result)>0))
	{
		$row=sqlread($result);
   		return $row[0];
   	}
	return "";
}

function sdtype($ftype,$sql_dbf)
{
	// sql_dbf = 0		&& from SQL to DBF
	// sql_dbf = 1		&& from DBF to SQL
	$sqldbf=array(	"CHAR"		=>"C",
					"DECIMAL"	=>"N",
					"FLOAT"		=>"N",
					"INT"		=>"INT",
					"TINYINT"	=>"INT",
					"DATE"		=>"D",
					"DATETIME"	=>"T",
					"VARCHAR"	=>"C",
					"CHAR"		=>"C",
					"TEXT"		=>"M",
					"LONGTEXT"	=>"M",
					"BIGINT"	=>"INT",
					"SMALLINT"	=>"INT",
					"MEDIUMINT"	=>"INT");

	
	$dbfsql=array(	"C"		=>"CHAR",
					"N"		=>"FLOAT",
					"I"		=>"INT",
					"T"		=>"DATETIME",
					"D"		=>"DATE",
					"M"		=>"LONGTEXT",
					"Y"		=>"FLOAT(10,2)",
					"B"		=>"FLOAT",
					"F"		=>"FLOAT",
					"L"		=>"BOOLEAN",
					"Q"		=>"VARBINARY",
					"V"		=>"VARCHAR",
					"W"		=>"LONGTEXT",
					"G"		=>"LONGTEXT");

	$pos=strpos($ftype,"(");
	if ($pos===false)
	{
		$ft=strtoupper(trim($ftype));
		$fl="";
	}
	else
	{
		$ft=strtoupper(trim(substr($ftype,0,$pos)));
		$fl=trim(substr($ftype,$pos));
	}	
	
	if ($sql_dbf==0)		// SQL to DBF
	{
		if (strpos($sqldbf[$ft],"INT,TINYINT,SMALLINT,MEDIUMINT,BIGINT")!==false) $fl="";
		return $sqldbf[$ft].$fl;
	}
	else	// DBF to SQL
	{
		if (strpos($sqldbf[$ft],"IDTM")!==false) $fl="";
		return $dbfsql[$ft].$fl;
	}	
}

function sqltodb($handle,$table)
{
	$cmd="describe ".$table;
	if ($handle) $result=sqlcmd($handle,$cmd);
	if (($result)&&(sqlcount($result)>0))
	{
		$tab='CREATE TABLE '.trim($table).' ( ';
		$ind="";
		$cmd="select ";
   		while ($row=sqlread($result))
   		{
			$dbtype=sdtype($row[1],0);
			if (strlen($dbtype)==0) return "";		// Field type not compatible
			$tab.='"'.trim($row[0]).'" '.$dbtype;
			if (trim($row[3])=="PRI") $tab.=" UNIQUE";
			else if (trim($row[3])=="MUL") $ind.=trim($row[0]).',';
			$tab.=',';
			
			if ($dbtype=="D") $cmd.="DATE_FORMAT(".trim($row[0]).",'%m/%d/%Y')";
			else if ($dbtype=="T") $cmd.="DATE_FORMAT(".trim($row[0]).",'%m/%d/%Y %H:%i:%S')";
			else $cmd.=trim($row[0]);
			$cmd.=',';
		}
		$tab=substr($tab,0,-1).')';
		$ind=substr($ind,0,-1);
		$cmd=substr($cmd,0,-1);
	}
	else return ""; 	

	$ret=$tab.chr(13).chr(10).$ind.chr(13).chr(10)."****************".chr(13).chr(10);
	
	$cmd.=" from $table";
	//$cmd="select * from $table";
	if ($handle) $result=sqlcmd($handle,$cmd);
	$fcount=sqlfcount($result);
	if (($result)&&(sqlcount($result)>0))
	while ($row=sqlread($result))
	{
		$line="";
		for ($i=0; $i<$fcount; $i++) $line.='"'.$row[$i].'",';	
		$line=substr($line,0,-1).chr(13).chr(10);
		$ret.=$line;
	}	
	return $ret;
}

function fulltable($table,$cmd)
{
	if (strlen($table)>1) return $table;
	
	// get the table lists from SELECT statement
	$pos=strpos(strtoupper($cmd),"FROM");
	$tlist=trim(substr($cmd,$pos+4));
	$pos=strpos(strtoupper($tlist),"WHERE");
	if ($pos!== false) $tlist=trim(substr($tlist,0,$pos));
	////////////////////////////////////////////
	
	$key=explode(",",$tlist);
	foreach ($key as $v)
	if (substr($v,-2)===" ".$table) return trim(substr($v,0,-2));
	return "";	
}

function webcmd($handle,$cmd)
{
	logfile($cmd);
	// Handle open as: $handle=mysql_pconnect($server,$uid,$pw);
	$linend='!'.chr(13).chr(10);
	$cmd=trim($cmd);
	if (strtoupper(substr($cmd,0,8))=="DESCRIBE")
	{
		$stru="(Field c(20), Type c(20), Null c(5), Key c(10), Default c(20), Extra c(10))";
		if ($handle) $result=sqlcmd($handle,$cmd);
		$rcount=0;
		if (($result)&&(($rcount=sqlcount($result))>0)) {}
		$ret=$stru.$linend."(".$rcount.",6)".$linend."****************".$linend;
		if ($rcount>0)
		while ($row=sqlread($result))
		{
			$line="";
			for ($i=0; $i<6; $i++) $line.='"'.$row[$i].'",';	
			$line=substr($line,0,-1).$linend;
			$ret.=$line;
		}	
		return $ret;
	}	
	else if (strtoupper(substr($cmd,0,6))=="SELECT")
	{
		if ($handle) $result=sqlcmd($handle,$cmd);
		$fcount=sqlfcount($result);		
		$stru="( ";
		for ($i=0; $i<$fcount; $i++)
		{
			$table=fulltable(mysqli_field_table($result,$i),$cmd);
			$fname=mysqli_field_name($result,$i);
			if (strlen(trim($fname))==0) $fname='n'.$i;
			$fname='"'.$fname.'"';
			//echo "$table==>$fname<br />";
			if ($handle) $result1=sqlcmd($handle,"SHOW FIELDS FROM ".$table." WHERE FIELD='".$fname."'");
			if (($result1)&&(sqlcount($result1)>0))
			{
				$row=sqlread($result1);
				$ftype=sdtype($row[1],0);
			}		
			$stru.=$fname." ".$ftype.",";
		}
		$stru=substr($stru,0,-1).")";
		$rcount=0;
		if (($result)&&(($rcount=sqlcount($result))>0)) {}
		$ret=$stru.$linend."(".$rcount.",".$fcount.")".$linend."****************".$linend;
		
		if ($rcount>0)
		while ($row=sqlread($result))
		{
			$line="";
			for ($i=0; $i<$fcount; $i++) $line.='"'.$row[$i].'",';	
			$line=substr($line,0,-1).$linend;
			$ret.=$line;
		}
		return $ret;
	}		
	else if ($handle) 
	{
		$result=sqlcmd($handle,$cmd);
		return "()";
	} 
	else return ""; 	
}

function webcmdi($handle,$cmd)
{
	logfile($cmd);
	$case="";
	$rcmd=trim($cmd);
	if (func_num_args()>2)	$case=func_get_arg(2);	//Table name case sensitive?
	// Handle open as: $handle=mysqli_connect($server,$uid,$pw);
	$linend='!'.chr(13).chr(10);
	
	if (strtoupper(substr($rcmd,0,8))=="DESCRIBE")
	{
		if (strlen($case)>0)
		{
			if ($case=='U') $rcmd=substr($rcmd,0,9).strtoupper(substr($rcmd,9));		//Upper case
			else $rcmd=substr($rcmd,0,9).strtolower(substr($rcmd,9));					//Lower case		
		}
		//return $rcmd;
		
		$stru="(Field c(20), Type c(20), Null c(5), Key c(10), Default c(20), Extra c(10))";
		if ($handle) $result=mysqli_query($handle,$rcmd);
		$rcount=0;
		if (($result)&&(($rcount=$result->num_rows)>0)) {}
		$ret=$stru.$linend."(".$rcount.",6)".$linend."****************".$linend;
		if ($rcount>0)
		while ($row=$result->fetch_row())
		{
			$line="";
			for ($i=0; $i<6; $i++) $line.='"'.$row[$i].'",';	
			$line=substr($line,0,-1).$linend;
			$ret.=$line;
		}	
		mysqli_free_result($result);
		return $ret;
	}	
	else if (strtoupper(substr($rcmd,0,6))=="SELECT")
	{
		if (strlen($case)>0)
		{
			$key=array("WHERE","GROUP","HAVING","WINDOW","ORDER","LIMIT","INTO","FOR");
			$minpos=10000;
			$start=strpos(strtoupper($rcmd),"FROM");
			for ($i=0; $i<8; $i++)
			{
				$pos=strpos(strtoupper($rcmd),$key[$i],$start+5);
				if (($pos!==false) && ($pos<$minpos)) $minpos=$pos;
			}
			if ($minpos==10000)	
			{
				if ($case=='U') $rcmd=substr($rcmd,0,$start+5).strtoupper(substr($rcmd,$start+5));		//Upper case
				else $rcmd=substr($rcmd,0,$start+5).strtolower(substr($rcmd,$start+5));					//Lower case				
			}
			else
			{
				if ($case=='U') $rcmd=substr($rcmd,0,$start+5).strtoupper(substr($rcmd,$start+5,$minpos-$start-5)).substr($rcmd,$minpos);	//Upper case
				else  $rcmd=substr($rcmd,0,$start+5).strtolower(substr($rcmd,$start+5,$minpos-$start-5)).substr($rcmd,$minpos);				//Lower case	
			}
		}
		//return $rcmd;

		if ($handle) $result=mysqli_query($handle,$rcmd);
		$fcount=mysqli_field_count($handle);		
		$stru="( ";
		for ($i=0; $i<$fcount; $i++)
		{
			$finfo = mysqli_fetch_field_direct($result,$i);
			//print_r($finfo);
			//echo "<br/>";
			//echo $finfo->type.",".$finfo->length.",".$finfo->decimals."<br/>";
			
			$fname=fieldformat($finfo->name);	
			if (strlen(trim($fname))==0) $fname='n'.$i;
			$fname='"'.$fname.'"';
			$flen=0+$finfo->max_length;
			if ($flen==0) $flen=1;	
			$stru.=$fname." ".chtype($finfo->type,$flen,0+$finfo->decimals).",";
		}
		$stru=substr($stru,0,-1).")";
		$rcount=$result->num_rows;
		$ret=$stru.$linend."(".$rcount.",".$fcount.")".$linend."****************".$linend;
		
		if ($rcount>0)
		while ($row = $result->fetch_row()) 
		{
			$line="";
			for ($i=0; $i<$fcount; $i++) $line.='"'.$row[$i].'",';	
			$line=substr($line,0,-1).$linend;
			$ret.=$line;
		}
		mysqli_free_result($result);
		return $ret;
	}		
	else if ($handle) 
	{
		if (strlen($case)>0) 
		{
			if (strtoupper(substr($rcmd,0,6))=="UPDATE")
			{
				$pos=strpos(strtoupper($rcmd),"SET",7);
				if ($case=='U') $rcmd=strtoupper(substr($rcmd,0,$pos)).substr($rcmd,$pos);
				else $rcmd=strtolower(substr($rcmd,0,$pos)).substr($rcmd,$pos);
			}
			elseif (strtoupper(substr($rcmd,0,6))=="DELETE")
			{
				$pos=strpos(strtoupper($rcmd),"FROM",7);
				for ($i=$pos+4; substr($rcmd,$i,1)==' '; $i++);
				$pos=strpos($rcmd,' ',$i);
				if ($pos===false)
				{
					if ($case=='U') $rcmd=substr($rcmd,0,$i).strtoupper(substr($rcmd,$i));
					else $rcmd=substr($rcmd,0,$i).strtolower(substr($rcmd,$i));
				}
				else
				{
					if ($case=='U') $rcmd=substr($rcmd,0,$i).strtoupper(substr($rcmd,$i,$pos-$i)).substr($rcmd,$pos);
					else $rcmd=substr($rcmd,0,$i).strtolower(substr($rcmd,$i,$pos-$i)).substr($rcmd,$pos);
				}	
			}
		}	
		//return $rcmd;
		
		//$result=mysqli_query($handle,$rcmd);
		$result=mysqli_multi_query($handle,$rcmd);
		if ($result) mysqli_free_result($result);
		return "()";
	} 
	else return ""; 	
}

function webcount($webstr)
{
	$linend='!'.chr(13).chr(10);
	if (($pos=strpos($webstr,$linend))==false) return 0;
	$st=substr($webstr,$pos+3);
	if (($pos=strpos($webstr,','))==false) return 0;
	return 0+substr($st,1,$pos-1);
}
function chtype($ftype,$flen,$fdec)
{
	$data_type = array(
     1=>"int",		//'tinyint',
     2=>"int",		//'smallint',
     3=>"int",		//'int',
     4=>"n",		//'float',
     5=>"n",		//'double',
     7=>"t",		//'timestamp',
     8=>"int",		//'bigint',
     9=>"int",		//'mediumint',
     10=>"d",		//'date',
     11=>"t",		//'time',
     12=>"t",		//'datetime',
     13=>"d",		//'year',
     14=>"d",		//'newdate',
     16=>"q",		//'bit',
     //252 is currently mapped to all text and blob types (MySQL 5.0.51a)
     246=>"n",		//'decimal',
     247=>"c",		//'enum',
     248=>"c",		//'set',
     249=>"m",		//'tiny_blob',
     250=>"m",		//'medium_blob',
     251=>"m",		//'long_blob',
     252=>"m",		//'blob',
     253=>"v",		//'varchar',
     254=>"c",		//'char',
     255=>"m");		//'geometry');
     
     if ($data_type[$ftype]=="n") 
     {
     	if ($flen<=$fdec) return "n(".(1+$fdec).",$fdec)";
     	return "n($flen,$fdec)";
     }	
     else return $data_type[$ftype]."($flen)";
}

function fieldformat($fieldname)
{
	$ret="";
	for ($i=0; ($i<10) && ($i<strlen($fieldname)); $i++)
	{
		$ch=substr($fieldname,$i,1);
		if (strpos("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ",strtoupper($ch))===false) $ret.='_';
		else $ret.=$ch;
	}	
	return $ret;
}

/**
 * @param mysql_resource - $queryResult - mysql query result
 * @param string - $rootElementName - root element name
 * @param string - $childElementName - child element name
  * USAGE :
  * $result = sqlcmd($handle,"SELECT * from company");
  * header("Content-Type: application/xml");
  * echo sqlToXml($result, "companies", "company");
 */
function sqlToXml($queryResult, $rootElementName, $childElementName)
{ 
    $xmlData = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n"; 
    $xmlData .= "<" . $rootElementName . ">";
 
    while($record = mysqli_fetch_object($queryResult))
    { 
        /* Create the first child element */
        $xmlData .= "<" . $childElementName . ">";
 
        for ($i = 0; $i < mysqli_num_fields($queryResult); $i++)
        { 
            $fieldName = mysqli_field_name($queryResult, $i); 
 
            /* The child will take the name of the table column */
            $xmlData .= "<" . $fieldName . ">";
 
            /* We set empty columns with NULL, or you could set 
                it to '0' or a blank. */
            if(!empty($record->$fieldName))
                $xmlData .= $record->$fieldName; 
            else
                //$xmlData .= "null"; 
 
            $xmlData .= "</" . $fieldName . ">"; 
        } 
        $xmlData .= "</" . $childElementName . ">"; 
    } 
    $xmlData .= "</" . $rootElementName . ">"; 
    return $xmlData; 
}
function foxcmd($fcmd)
{
	$pos=strpos($fcmd,"?");
	if ($pos==FALSE) return $fcmd;
	if ($_FILES["file"]["error"] > 0) return "";
	$file=get_file_content($_FILES["file"]["tmp_name"]);
	
	$rcmd=$fcmd;
	$i=0;
	$ret="";
	while ($pos)
	{
		$ret.=substr($rcmd,$i,$pos)."`".getblock($file,$i++)."`";
		$rcmd=substr($rcmd,$pos);
		if ($pos=strpos($rcmd,",")===FALSE)
		if ($pos=strpos($rcmd," ")===FALSE)
		if ($pos=strpos($rcmd,")")===FALSE) return $ret;
		
		$rcmd=substr($rcmd,$pos);
		$pos=strpos($fcmd,"?");
		
	}
	$ret.=$rcmd;		
	return $ret;
}

/**************************************************************************************************************
 Fcode:
* 1 -- Authentcating employee
	&& msg=url;MerchantID;Password;CompanyID // Return: Rcode;YES/NO;MerchantID
* 2 -- Adding a sales transaction	
	&& msg=CustomerID;Amount(Points);Unitprice;Unitpoints 
	&& Return: Rcode;TransID;Servicecode;Rewardpoints;CustBalance;Mercpts,MercBalance,ReferID;ReferPTS 
	&& if Unitprice ommitted, the parameter is Points, else Amount
	&& if Unitprice=0, it will be assigned from default in database
* 3 -- Cancelling a sales transaction
* 4 -- Redeeming card points for a sales transaction
	&& msg=CustomerID;Amount(Points);Unitprice;Unitpoints
	&& Return: Rcode;TransID;Servicecode;Redeempoints;OwedAmount;CustBalance;MercPTS;MercBalance
	&& if Unitprice ommitted, the parameter is Points, else Amount
	&& if Unitprice=0, it will be assigned from default in database
* 11 -- Authenticating customer
* 12 -- Get customer profile
* 13 -- Get customer reward info 
* 14 -- Change password
****************************************************************************************************************/
function easyreward($handle,$fcode,$msg)
{
	global $server,$sid,$spw,$sdb;
	
	// $msg = login;password
	if ($fcode==1)		//Authentcating employee
	{
		$cmd='SELECT mid,cid,(SELECT program FROM myself WHERE cid=m.cid) program from merc m WHERE login="'.getword($msg,1,';').'" AND password="'.getword($msg,2,';').'" and type="1"';
		if ($handle) $result=sqlcmd($handle,$cmd);
    	if (($result)&&($cnt=sqlcount($result)>0))
    	{
    		$row=sqlread($result);
			$mmid=$row[0];
			$ccid=$row[1];
			if (strlen($row[2])>0) $ccid.=';'.$row[2];
			
			return "0;YES;$mmid;$ccid;[$server,$sid,$spw,$sdb]";			//Successful
		}
		elseif ($cnt==0) return "9;NO";			//Authentication failed	
		else return "2;NO";						// Communication error
	}	
	elseif ($fcode==2)							//Adding a sales transaction
	{
		//$msg = mid,cid;custid;cust_points_balance;amount;price_of_point;point_of_price
		$easymid=getword($msg,1,';');
		$custid=getword($msg,2,';');
		$custbal=0+getword($msg,3,';');
		$points=0+getword($msg,4,';');			// Get amount
		$unitprice=0+getword($msg,5,';');
		$unitpoint=0+getword($msg,6,';');
	
		if ($unitprice==0) return "9;D";		// Reward feature disabled 
	
		$cmd='SELECT ID,REWRATE,REWPFEE,BALANCE,CRLIMIT,CID from merc m WHERE mid="'.getword($easymid,1,',').'" AND cid="'.getword($easymid,2,',').'" AND TYPE="1"';
		if ($handle) $result=sqlcmd($handle,$cmd);
    	if (($result)&&($cnt=sqlcount($result)<=0))		//Merchant verification failed
		{
			if ($cnt==0) return "9;M";					// Authentication failed	
			else return "2";							// Communication error
		}
		$row=sqlread($result);
		$mercid=$row[0];
		$ecloud=$row[1];
		$eclpts=$row[2];
		$mercbal=$row[3];
		$mcrlimit=$row[4];
	
		$points=intval($points/$unitprice)*$unitpoint;			// points rewarded
		$ecloud=intval($points*$ecloud/100+0.9)+$eclpts;		// Merchant points to cost
	
		$refpts=0;
		$refid="";
		if (substr($custid,0,3)!="!!E")
		{
			$cmd='SELECT referid FROM merc WHERE ID="'.$custid.'"';
			if ($handle) $result=sqlcmd($handle,$cmd);
    		if (($result)&&(sqlcount($result)>0))
    		{
    			$row=sqlread($result);
				$refid=$row[0];
				$cmd='SELECT refrate FROM merc WHERE id="'.$refid.'"';
				if ($handle) $result=sqlcmd($handle,$cmd);
    			if (($result)&&(sqlcount($result)>0))
    			{
    				$row=sqlread($result);
					$refpts=$row[0];							// Points discount rate for referal
				}
			}
		}			
		if (strlen($refid)>0) $refpts=$points*$refpts/100;		// Points for referal
		
		if ($mercbal+$mcrlimit<$points+$ecloud) return "9;M";	// Merchant no enough points to reward

		$transid="0000000001";
		$cmd='SELECT MAX(TRANSID) FROM transaction';
		if ($handle) $result=sqlcmd($handle,$cmd);
   		if (($result)&&(sqlcount($result)>0))
   		{
   			$row=sqlread($result);
			$transid=substr(10000000001+$row[0],1);
		}	

		$udt=date("Y/m/d H:i:s");
		$cmd='INSERT INTO transaction (transid,dt,type,mercid,mercpts,custid,custpts,referid,referpts,commision)';
		$cmd.=' values ("'.$transid.'","'.$udt.'","1","'.$mercid.'",'.(-$points-$ecloud).',"';
		$cmd.=$custid.'",'.$points.',"'.$refid.'",'.$refpts.','.($ecloud-$refpts).')';
		if ($handle) $result=sqlcmd($handle,$cmd);

		$cmd='UPDATE merc SET LAST="'.$udt.'", BALANCE=BALANCE-'.($points+$ecloud).' WHERE ID="'.$mercid.'"';
		if ($handle) $result=sqlcmd($handle,$cmd);

		if (substr($custid,0,3)=="!!E") $cmd='UPDATE SECURITY SET points=points+'.$points.' WHERE ID="'.$custid.'"';
		else $cmd='UPDATE merc SET LAST="'.$udt.'", BALANCE=BALANCE+'.$points.' WHERE ID="'.$custid.'"';
		if ($handle) $result=sqlcmd($handle,$cmd);
		
		if (($refpts>0) && (strlen($refid)>0))
		{
			$cmd='UPDATE merc SET LAST="'.$udt.'", BALANCE=BALANCE+'.$refpts.' WHERE ID="'.$refid.'"';
			if ($handle) $result=sqlcmd($handle,$cmd);

		}
		
		return "0;$transid;$points;".($custbal+$points).";".($points+$ecloud).";".($mercbal-$points-$ecloud).";$refid;$refpts";	
	}
	elseif ($fcode==3)
	{}
	elseif ($fcode==4)						//Redeeming card points for a sales transaction
	{
		//$msg = mid,cid;custid;cust_points_balance;amount;price_of_point;point_of_price
		$easymid=getword($msg,1,';');
		$custid=getword($msg,2,';');		
		$custbal=0+getword($msg,3,';');			// Customer points balance
		$points=0+getword($msg,4,';');			// Amount asking for redeem
		$unitprice=0+getword($msg,5,';');		// Redeem $ to pts
		$unitpoint=0+getword($msg,6,';');		// Redeem pts to $
		if ($custbal<$unitpoint) return "9;C";	// Customer no enough points to redeem

		if ($unitprice==0) return "9;D";		// Redeem function not allowed
 	
		$cmd='SELECT ID,REDDOLLAR,REDPOINT,REDRATE,REDPFEE,BALANCE,CRLIMIT,CID from merc WHERE mid="'.getword($easymid,1,',').'" AND cid="'.getword($easymid,2,',').'" AND TYPE="1"';
		if ($handle) $result=sqlcmd($handle,$cmd);
 		if (($result)&&($cnt=sqlcount($result)<=0))
   		{
    		if ($cnt==0) return "9;M";			//Authentication failed
    		else return "2";					//Communication error
    	}		
		$row=sqlread($result);
		$mercid=$row[0];
		$rreddollar=$row[1];
		$rredpiont=$row[2];
		$ecloud=$row[3];						// Merchant discount(cost) rate
		$eclpts=$row[4];						// Merchant discount(cost) points
		$mercbal=$row[5];
		$mcrlimit=$row[6];

		$points=intval($points/$unitprice)*$unitpoint;			// Points needed to redeem
		
		if ($points>$custbal)									// If customer points not enough 
			$points=intval($custbal/$unitpoint)*$unitpoint;		// actual points will be used
	
		$oweamount=0+getword($msg,4,';')-intval($points/$unitpoint)*$unitprice;		// Rest amount after redeemed(partial redeemed)

		$ecloud=intval($points*$ecloud/100+0.9)+$eclpts;		// Merchant rounded up points cost
		if ($ecloud>$points+$mercbal+$mcrlimit) return "9;M";	// Merchant no enough points to cost
	
		$transid="0000000001";
		$cmd='SELECT MAX(TRANSID) FROM transaction';
		if ($handle) $result=sqlcmd($handle,$cmd);
   		if (($result)&&(sqlcount($result)>0))
   		{
   			$row=sqlread($result);
			$transid=substr(10000000001+$row[0],1);
		}	

		$udt=date("Y/m/d H:i:s");
	
		$cmd='INSERT INTO transaction (transid,dt,type,mercid,mercpts,custid,custpts,referid,referpts,commision)';
		$cmd.=' values ("'.$transid.'","'.$udt.'","2","'.$mercid.'",'.($points-$ecloud).',"'.$custid.'",'.(-$points).',"",0,'.$ecloud.')';
		if ($handle) $result=sqlcmd($handle,$cmd);

		$cmd='UPDATE merc SET LAST="'.$udt.'", BALANCE=BALANCE+'.($points-$ecloud).' WHERE ID="'.$mercid.'"';
		if ($handle) $result=sqlcmd($handle,$cmd);

		if (substr($custid,1,3)=="!!E") $cmd='UPDATE security SET points=points-'.$points.' WHERE ID="'.$custid.'"';
		else $cmd='UPDATE merc SET LAST="'.$udt.'", BALANCE=BALANCE-'.$points.' WHERE ID="'.$custid.'"';
		if ($handle) $result=sqlcmd($handle,$cmd);
		
		return "0;$transid;$points;$oweamount;".($custbal-$points).";".($points-$ecloud).";".($mercbal+$points-$ecloud);
	}
}
?>